/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.jopencage;

import com.byteowls.jopencage.model.JOpenCageForwardRequest;
import com.byteowls.jopencage.model.JOpenCageRequest;
import com.byteowls.jopencage.model.JOpenCageResponse;
import com.byteowls.jopencage.model.JOpenCageReverseRequest;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JOpenCageGeocoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JOpenCageGeocoder.class);
    private static final String OPENCAGE_HOST = "api.opencagedata.com";
    private static final String OPENCAGE_PATH = "/geocode/v1/";
    private boolean httpsEnabled = false;
    private String host = "api.opencagedata.com";
    private String path = "/geocode/v1/";
    private String format = "json";
    private String apiKey;

    public JOpenCageGeocoder(String apiKey) {
        this.apiKey = apiKey;
    }

    public JOpenCageResponse forward(JOpenCageForwardRequest request) {
        return this.sendRequest(request);
    }

    public JOpenCageResponse reverse(JOpenCageReverseRequest request) {
        return this.sendRequest(request);
    }

    public URI buildUri(JOpenCageRequest jOpenCageRequest) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder();
        if (this.httpsEnabled) {
            uriBuilder.setScheme("https");
        } else {
            uriBuilder.setScheme("http");
        }
        uriBuilder.setHost(this.host).setPath(this.path + this.format);
        for (Map.Entry<String, String> e : jOpenCageRequest.getParameter().entrySet()) {
            if (e.getValue() == null) continue;
            uriBuilder.setParameter(e.getKey(), e.getValue());
        }
        uriBuilder.setParameter("key", this.apiKey);
        return uriBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JOpenCageResponse sendRequest(JOpenCageRequest jOpenCageRequest) {
        URI url = null;
        try {
            url = this.buildUri(jOpenCageRequest);
            LOGGER.info("JOpencage request url '{}'", (Object)url);
        }
        catch (URISyntaxException e1) {
            LOGGER.error("", (Throwable)e1);
        }
        if (url == null) {
            LOGGER.error("No jopencage request url build!");
            return null;
        }
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().build();){
            HttpGet getRequest = new HttpGet(url);
            AbstractResponseHandler<JOpenCageResponse> rh = new AbstractResponseHandler<JOpenCageResponse>(){

                public JOpenCageResponse handleEntity(HttpEntity entity) throws IOException {
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    return (JOpenCageResponse)mapper.readValue(entity.getContent(), JOpenCageResponse.class);
                }
            };
            JOpenCageResponse jOpenCageResponse = (JOpenCageResponse)httpclient.execute((HttpUriRequest)getRequest, (ResponseHandler)rh);
            return jOpenCageResponse;
        }
        catch (HttpResponseException e) {
            switch (e.getStatusCode()) {
                case 400: {
                    LOGGER.error("Invalid request (bad request; a required parameter is missing)!");
                    return null;
                }
                case 402: {
                    LOGGER.error("Valid request but quota exceeded (payment required)!");
                    return null;
                }
                case 403: {
                    LOGGER.error("Invalid or missing api key!");
                    return null;
                }
                case 404: {
                    LOGGER.error("Invalid API endpoint!");
                    return null;
                }
                case 408: {
                    LOGGER.error("Timeout; you can try again!");
                    return null;
                }
                case 410: {
                    LOGGER.error("Request too long!");
                    return null;
                }
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public void setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getApiKey() {
        return this.apiKey;
    }
}

